#!/bin/bash

# SAAM Cabins - Admin Panel Activation Script
echo "🔧 SAAM Cabins Admin Panel Setup"
echo "================================"
echo ""

# Check if admin files exist
if [ ! -f "src/app/page-admin.tsx" ]; then
    echo "❌ Error: Admin files not found!"
    echo "Please ensure you have the admin-enabled files in your project."
    exit 1
fi

# Backup current homepage if it exists
if [ -f "src/app/page.tsx" ]; then
    echo "📦 Backing up current homepage..."
    if [ ! -f "src/app/page-static.tsx" ]; then
        mv src/app/page.tsx src/app/page-static.tsx
        echo "✅ Static homepage backed up to page-static.tsx"
    else
        echo "⚠️  Static backup already exists, creating timestamped backup..."
        cp src/app/page.tsx "src/app/page-backup-$(date +%Y%m%d-%H%M%S).tsx"
        echo "✅ Backup created with timestamp"
    fi
fi

# Activate admin homepage
echo "🔄 Activating admin-powered homepage..."
cp src/app/page-admin.tsx src/app/page.tsx
echo "✅ Admin homepage activated!"

# Create data directory
echo "📁 Creating data directory..."
mkdir -p data
mkdir -p public/uploads
echo "✅ Directories created"

# Create environment file if it doesn't exist
if [ ! -f ".env.local" ]; then
    echo "⚙️  Creating environment file..."
    cat > .env.local << EOL
# Admin Panel Configuration
SECRET_COOKIE_PASSWORD=saam_cabins_admin_secret_key_change_this_in_production_environment_2025
ADMIN_USERNAME=admin
ADMIN_PASSWORD=saamcabins2025

# Next.js Configuration  
NEXT_PUBLIC_SITE_URL=http://localhost:3000
EOL
    echo "✅ Environment file created"
    echo "⚠️  Important: Change the admin password in .env.local for security!"
fi

echo ""
echo "🎉 Admin Panel Setup Complete!"
echo ""
echo "📋 What's been set up:"
echo "• Built-in admin panel with secure login"
echo "• Content management for all website sections"
echo "• Image upload and management system"
echo "• JSON-based data storage (no database required)"
echo "• Company info, products, features, testimonials management"
echo ""
echo "🔑 Admin Access:"
echo "• URL: http://localhost:3000/admin/login"
echo "• Username: admin"
echo "• Password: saamcabins2025"
echo ""
echo "⚡ Next steps:"
echo "1. Run 'npm run dev' to start your website"
echo "2. Visit http://localhost:3000/admin/login to access admin panel"
echo "3. Change the admin password in .env.local for security"
echo "4. Start adding your content through the admin interface"
echo ""
echo "📚 Features available:"
echo "• ✅ Company information management"
echo "• ✅ Product catalog with images and specs"
echo "• ✅ Homepage features and selling points"
echo "• ✅ Customer testimonials with ratings"
echo "• ✅ Project portfolio management"
echo "• ✅ Image upload and optimization"
echo "• ✅ No external dependencies or subscriptions"
echo ""